/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.AddEdit;
import erkka.BaseObject;
import erkka.DrawingArea;
import erkka.InformationPanel;
import erkka.Line;
import erkka.MessageBox;
import erkka.MoveEdit;
import erkka.PngEncoderB;
import erkka.PrintUtilities;
import erkka.ProgresWaitDialog;
import erkka.RemoveEdit;
import erkka.Rules;
import erkka.Symbol;
import erkka.SymbolContainer;
import erkka.SymbolFactory;
import erkka.TopPanel;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class Control {
    protected UndoManager undoManager = new UndoManager();
    protected UndoableEditSupport undoSupport = new UndoableEditSupport();
    private Symbol foo;
    private TopPanel topPanel;
    private DrawingArea area;
    private InformationPanel infoPanel;
    private BaseObject temp_obj;
    private BaseObject tempo;
    private BaseObject temp;
    private Line temp2;
    private int mousepX;
    private int mousepY;
    private int dragpX = 0;
    private int dragpY = 0;
    SymbolFactory symbolFactory = new SymbolFactory();
    private Rules rules;
    private NodeList configL;
    private Document doc;
    private boolean dragged = false;
    private ProgresWaitDialog transformationDialog = new ProgresWaitDialog();

    public Control(DrawingArea area, TopPanel topPanel, InformationPanel info) {
        this.area = area;
        this.topPanel = topPanel;
        this.infoPanel = info;
        this.transformationDialog.pack();
    }

    public boolean initProgram(NodeList configL) {
        NodeList fieldL;
        NodeList ruleL;
        Element config = (Element)configL.item(0);
        if (config == null) {
            return false;
        }
        this.clearDrawingArea();
        this.symbolFactory = new SymbolFactory();
        this.infoPanel.setSymbolF(this.symbolFactory);
        this.rules = new Rules(this.area.getLineTable());
        String oName = "error in config file";
        NodeList objectL = config.getElementsByTagName("objectC");
        for (int i = 0; i < objectL.getLength(); ++i) {
            Element element = (Element)objectL.item(i);
            oName = element.getAttribute("name");
            this.symbolFactory.addNewSymbol(oName, element.getAttribute("type"), element.getAttribute("height"), element.getAttribute("width"), element.getAttribute("color"), element.getAttribute("contains"));
            ruleL = element.getElementsByTagName("rules");
            Element ruleE = (Element)ruleL.item(0);
            if (ruleE != null) {
                ruleL = ruleE.getElementsByTagName("rule");
            }
            for (int k = 0; k < ruleL.getLength(); ++k) {
                ruleE = (Element)ruleL.item(k);
                this.rules.addNewRule(oName, ruleE.getAttribute("friend"), ruleE.getAttribute("max"));
            }
            fieldL = element.getElementsByTagName("fieldC");
            for (int j = 0; j < fieldL.getLength(); ++j) {
                element = (Element)fieldL.item(j);
                if (element.getFirstChild() != null) {
                    this.symbolFactory.initSymbolFields(oName, element.getAttribute("name"), element.getFirstChild().getNodeValue(), element.getAttribute("select"));
                    continue;
                }
                this.symbolFactory.initSymbolFields(oName, element.getAttribute("name"), " ", element.getAttribute("select"));
            }
        }
        Color bgColor = Color.white;
        Color inColor = SystemColor.activeCaptionBorder;
        Color topColor = SystemColor.activeCaptionBorder;
        fieldL = config.getElementsByTagName("colors");
        try {
            Element elem = (Element)fieldL.item(0);
            if (elem != null) {
                bgColor = Color.decode(elem.getAttribute("bground"));
                inColor = Color.decode(elem.getAttribute("infopanel"));
                topColor = Color.decode(elem.getAttribute("toppanel"));
            }
        }
        catch (Exception j) {
            // empty catch block
        }
        this.area.setBackground(bgColor);
        this.infoPanel.setBackground(inColor);
        this.topPanel.setBackground(topColor);
        this.clearVariables();
        Enumeration e = this.symbolFactory.getSymbols();
        while (e.hasMoreElements()) {
            BaseObject bas = (BaseObject)e.nextElement();
            this.topPanel.addNewButton(bas.getFieldData(0));
            this.topPanel.revalidate();
        }
        this.topPanel.createClearButton();
        objectL = config.getElementsByTagName("selectionbox");
        for (int i = 0; i < objectL.getLength(); ++i) {
            Element element = (Element)objectL.item(i);
            oName = element.getAttribute("name");
            this.symbolFactory.addNewSelectionBox(oName, element.getAttribute("type"));
            ruleL = element.getElementsByTagName("choice");
            for (int k = 0; k < ruleL.getLength(); ++k) {
                Element choiceE = (Element)ruleL.item(k);
                if (choiceE.hasChildNodes()) {
                    NodeList nL = choiceE.getElementsByTagName("extra_data_field");
                    Element ex = (Element)nL.item(0);
                    this.symbolFactory.addChoiceInSelection(oName, choiceE.getAttribute("name"), ex.getAttribute("name"), ex.getAttribute("default"));
                    continue;
                }
                this.symbolFactory.addChoiceInSelection(oName, choiceE.getAttribute("name"), null, null);
            }
        }
        this.area.setModified(false);
        return true;
    }

    public void clearVariables() {
        this.topPanel.removeAll();
        this.topPanel.NullSelected();
        this.infoPanel.setSymbolData(null);
        this.area.setModified(false);
    }

    public boolean openDrawingInFile(String fileName) {
        NodeList fieldL;
        Element element;
        int i;
        String xmlfile = fileName;
        String oName = "error in save file";
        int oX = 0;
        int oY = 0;
        MessageBox msg = null;
        DOMParser parser = new DOMParser();
        try {
            parser.parse(xmlfile);
        }
        catch (SAXParseException e) {
            msg = new MessageBox();
            msg.setTitle("Error in parsing file ".concat(String.valueOf(String.valueOf(fileName))));
            msg.askOkay(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            msg = new MessageBox();
            msg.setTitle("Error in parsing file ".concat(String.valueOf(String.valueOf(fileName))));
            msg.askOkay(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        this.doc = parser.getDocument();
        this.configL = this.doc.getElementsByTagName("configuration");
        if (!this.initProgram(this.configL)) {
            msg = new MessageBox();
            msg.setTitle("Error in parsing file ".concat(String.valueOf(String.valueOf(fileName))));
            msg.askOkay("Konffifile on paskana!!!\nKuvaa ei voida avata!\n");
            return false;
        }
        NodeList objectL = this.doc.getElementsByTagName("drawing");
        Element drawing = (Element)objectL.item(0);
        if (drawing == null) {
            msg = new MessageBox();
            msg.setTitle("Error in parsing file ".concat(String.valueOf(String.valueOf(fileName))));
            msg.askOkay("No <drawing> -element found.");
            return false;
        }
        objectL = drawing.getElementsByTagName("object");
        for (i = 0; i < objectL.getLength(); ++i) {
            element = (Element)objectL.item(i);
            Symbol newSymbol = (Symbol)this.symbolFactory.createSymbol(element.getAttribute("name"));
            fieldL = element.getElementsByTagName("id");
            newSymbol.SetID(Integer.parseInt(fieldL.item(0).getFirstChild().getNodeValue().substring(2)));
            fieldL = element.getElementsByTagName("field");
            for (int j = 0; j < fieldL.getLength(); ++j) {
                element = (Element)fieldL.item(j);
                if (element.getFirstChild() == null) continue;
                if (element.getAttribute("name").equalsIgnoreCase("coordinate_x")) {
                    oX = Integer.parseInt(element.getFirstChild().getNodeValue());
                    continue;
                }
                if (element.getAttribute("name").equalsIgnoreCase("coordinate_y")) {
                    oY = Integer.parseInt(element.getFirstChild().getNodeValue());
                    this.area.AddObj(newSymbol, oX, oY);
                    this.setListeners(newSymbol);
                    continue;
                }
                newSymbol.SetProperty(element.getFirstChild().getNodeValue(), newSymbol.getDataFieldIndex(element.getAttribute("name")));
            }
        }
        this.area.setModified(false);
        objectL = this.doc.getElementsByTagName("join");
        if (objectL == null) {
            return true;
        }
        for (i = 0; i < objectL.getLength(); ++i) {
            element = (Element)objectL.item(i);
            Line newLine = (Line)this.symbolFactory.createSymbol("Line");
            fieldL = element.getElementsByTagName("idref");
            element = (Element)fieldL.item(0);
            newLine.SetTarget1(this.area.getObjByID(Integer.parseInt(element.getFirstChild().getNodeValue().substring(2))));
            this.setListeners(newLine);
            element = (Element)fieldL.item(1);
            newLine.SetTarget2(this.area.getObjByID(Integer.parseInt(element.getFirstChild().getNodeValue().substring(2))));
            String cont = this.symbolFactory.isContainer(newLine.GetTarget1().getFieldData(0));
            if (cont != null) {
                if (newLine.GetTarget2().getFieldData(0).equalsIgnoreCase(cont) && newLine.GetTarget1() instanceof SymbolContainer) {
                    ((SymbolContainer)newLine.GetTarget1()).addSymbol(newLine.GetTarget2());
                    newLine.drawYourselfBounds(false);
                }
            } else {
                cont = this.symbolFactory.isContainer(newLine.GetTarget2().getFieldData(0));
                if (cont != null && newLine.GetTarget1().getFieldData(0).equalsIgnoreCase(cont) && newLine.GetTarget2() instanceof SymbolContainer) {
                    ((SymbolContainer)newLine.GetTarget2()).addSymbol(newLine.GetTarget1());
                    newLine.drawYourselfBounds(false);
                }
            }
            element = (Element)objectL.item(i);
            fieldL = element.getElementsByTagName("field");
            if ((element = (Element)fieldL.item(0)) != null && element.getFirstChild() != null) {
                newLine.SetProperty(element.getFirstChild().getNodeValue(), 1);
            }
            this.area.AddObj(newLine, 1, 1);
        }
        this.area.setModified(false);
        this.area.revalidate();
        this.area.repaint();
        this.area.selectAll();
        this.area.moveSelectedObjects(0, 1);
        this.area.setFocusVectorNull();
        this.area.repaint();
        this.area.requestFocus();
        return true;
    }

    public TopPanel getTopPanel() {
        return this.topPanel;
    }

    public void setListeners(BaseObject newSymbol) {
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Control.this.obj_mousePressed(e);
            }
        });
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                Control.this.obj_mouseEntered(e);
            }
        });
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Control.this.obj_mouseReleased(e);
            }
        });
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                Control.this.obj_mouseExited(e);
            }
        });
        newSymbol.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                Control.this.obj_mouseDragged(e);
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void AddComponent(int CoordX, int CoordY, MouseEvent e) {
        String SelectedName;
        if (!e.isControlDown()) {
            this.area.setFocusVectorNull();
        }
        if ((e.getModifiers() & 4) != 0) {
            this.temp2 = null;
            this.area.setLine(0, 0, 0, 0);
            this.topPanel.NullSelected();
        }
        if ((SelectedName = this.topPanel.GetSelected()) == null || SelectedName.length() == 0) {
            this.infoPanel.setSymbolData(null);
            return;
        }
        this.temp_obj = this.symbolFactory.createSymbol(SelectedName);
        if (!(this.temp_obj instanceof Line)) {
            this.setListeners(this.temp_obj);
            this.area.AddObj(this.temp_obj, CoordX, CoordY);
            AddEdit edit = new AddEdit(this.area, this.temp_obj);
            this.undoSupport.postEdit(edit);
            this.temp_obj.SetObjectFocus(true);
            this.infoPanel.setSymbolData(this.temp_obj);
            this.area.repaint();
        }
        this.area.requestFocus();
    }

    public void obj_mouseEntered(MouseEvent e) {
        if (this.topPanel.GetSelected() == null) {
            return;
        }
        if (this.topPanel.GetSelected().equalsIgnoreCase("line") && e.getComponent() instanceof Symbol) {
            this.foo = (Symbol)e.getComponent();
            this.foo.SetObjectFocus(true);
            this.foo.repaint();
            this.area_MouseMoved(e.getX() + this.foo.getX(), e.getY() + this.foo.getY());
        }
    }

    public void obj_mouseExited(MouseEvent e) {
        if (this.topPanel.GetSelected() == null) {
            return;
        }
        if (this.topPanel.GetSelected().equalsIgnoreCase("line")) {
            this.foo.SetObjectFocus(false);
            this.foo.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void obj_mousePressed(MouseEvent e) {
        this.mousepX = e.getX();
        this.mousepY = e.getY();
        if ((e.getModifiers() & 4) != 0) {
            this.temp2 = null;
            this.area.setLine(0, 0, 0, 0);
            this.topPanel.NullSelected();
            return;
        }
        if (this.topPanel.GetSelected().equalsIgnoreCase("line") && e.getComponent() instanceof Symbol) {
            this.area.setFocusVectorNull();
            this.area.repaint();
            if (this.temp2 != null) {
                if (!this.rules.canJoin(this.temp2.GetTarget1(), (Symbol)e.getComponent())) return;
                this.temp2.SetTarget2((Symbol)e.getComponent());
                this.area.AddObj(this.temp2, 0, 0);
                this.temp2.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        Control.this.obj_mousePressed(e);
                    }
                });
                this.area.setLine(0, 0, 0, 0);
                AddEdit edit = new AddEdit(this.area, this.temp2);
                this.undoSupport.postEdit(edit);
                ((Symbol)e.getComponent()).SetObjectFocus(false);
                this.area.repaint();
                this.temp2 = null;
                return;
            } else {
                this.temp2 = (Line)this.symbolFactory.createSymbol("Line");
                this.area.addMouseMotionListener(new MouseMotionListener(){

                    public void mouseDragged(MouseEvent e) {
                    }

                    public void mouseMoved(MouseEvent e) {
                        Control.this.area_MouseMoved(e);
                    }
                });
                try {
                    this.temp2.SetTarget1((Symbol)e.getComponent());
                    return;
                }
                catch (Exception edit) {}
            }
            return;
        } else {
            this.temp = (BaseObject)e.getComponent();
            String cont = this.symbolFactory.isContainer(this.temp.getFieldData(0));
            if (cont != null) {
                int x = e.getX();
                int y = e.getY();
                if (cont.equalsIgnoreCase(this.topPanel.GetSelected())) {
                    BaseObject ba = this.symbolFactory.createSymbol(this.topPanel.GetSelected());
                    Line l = (Line)this.symbolFactory.createSymbol("Line");
                    l.SetTarget1((Symbol)this.temp);
                    l.SetTarget2((Symbol)ba);
                    l.drawYourselfBounds(false);
                    ba.drawYourselfBounds(false);
                    this.area.AddObj(l, 5, 5);
                    this.area.AddObj(ba, 10, 10);
                    ((SymbolContainer)this.temp).addSymbol((Symbol)ba);
                } else {
                    BaseObject b = this.temp;
                    for (int i = 0; i < ((SymbolContainer)this.temp).table.size(); ++i) {
                        BaseObject base = (BaseObject)((SymbolContainer)this.temp).table.get(i);
                        if (base.getY() - this.temp.getY() >= y || base.getY() - this.temp.getY() + base.getHeight() <= y) continue;
                        this.temp = base;
                        break;
                    }
                }
            }
            if (e.isControlDown() && this.temp.getObjectFocus()) {
                this.dragpX = this.area.getFocusTableLeft();
                this.dragpY = this.area.getFocusTableTop();
            } else if (e.isControlDown()) {
                this.temp.SetObjectFocus(true);
                this.dragpX = this.area.getFocusTableLeft();
                this.dragpY = this.area.getFocusTableTop();
                this.infoPanel.setSymbolData(this.temp);
                if (this.area.FocusVector.size() > 1) {
                    this.infoPanel.setSymbolData(null);
                }
            } else {
                this.area.setFocusVectorNull();
                this.temp.SetObjectFocus(true);
                this.dragpX = this.area.getFocusTableLeft();
                this.dragpY = this.area.getFocusTableTop();
                this.infoPanel.setSymbolData(this.temp);
            }
            this.area.repaint();
        }
    }

    public void obj_mouseDragged(MouseEvent e) {
        if (((BaseObject)e.getComponent()).getObjectFocus()) {
            int mx = e.getX() - this.mousepX;
            int my = e.getY() - this.mousepY;
            this.area.moveSelectedObjects(mx, my);
            this.dragged = true;
        }
        this.area.repaint();
    }

    public void obj_mouseReleased(MouseEvent e) {
        if (!this.dragged) {
            return;
        }
        MoveEdit edit = new MoveEdit(this.area, this.area.getFocusVector(), this.dragpX, this.dragpY);
        this.undoSupport.postEdit(edit);
        this.dragged = false;
    }

    public void area_MouseMoved(MouseEvent e) {
        this.area_MouseMoved(e.getX(), e.getY());
    }

    public void area_MouseMoved(int x, int y) {
        if (this.temp2 != null) {
            if (!(this.symbolFactory.createSymbol(this.topPanel.GetSelected()) instanceof Line)) {
                this.temp2 = null;
                this.area.setLine(0, 0, 0, 0);
                this.area.repaint();
                return;
            }
            this.area.setLine(this.temp2.GetTarget1().GetMiddlePoint().x, this.temp2.GetTarget1().GetMiddlePoint().y, x, y);
            this.area.repaint();
        }
    }

    public void keyType(KeyEvent e) {
    }

    public void hideAllHotSpots() {
        this.area.hideLineHotSpots();
    }

    public boolean saveDrawingInFile(String fileName, boolean changeState) {
        MessageBox msg = null;
        if (changeState && !this.area.getModified()) {
            return true;
        }
        try {
            OutputFormat format = new OutputFormat("xml", "utf-8", true);
            FileOutputStream out = new FileOutputStream(fileName);
            XMLSerializer serial = new XMLSerializer(out, format);
            serial.asDOMSerializer();
            Document the_doc = this.getAllSymbolsInDoc();
            if (the_doc == null) {
                msg = new MessageBox();
                msg.setTitle("Error in saving file ".concat(String.valueOf(String.valueOf(fileName))));
                msg.askOkay("Cannot find any data to be saved.");
                boolean bl = false;
                return bl;
            }
            serial.serialize(this.doc);
            out.close();
        }
        catch (Exception e) {
            msg = new MessageBox();
            msg.setTitle("Error in saving file ".concat(String.valueOf(String.valueOf(fileName))));
            msg.askOkay(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        if (changeState) {
            this.area.setModified(false);
        }
        return true;
    }

    public Document getAllSymbolsInDoc() {
        if (this.doc == null) {
            return null;
        }
        NodeList m = this.doc.getElementsByTagName("configuration");
        NodeList n = this.doc.getElementsByTagName("colors");
        Element color = (Element)n.item(0);
        if (color != null) {
            color.setAttribute("bground", String.valueOf(this.area.getBackground().getRGB()));
            color.setAttribute("infopanel", String.valueOf(this.infoPanel.getBackground().getRGB()));
            color.setAttribute("toppanel", String.valueOf(this.topPanel.getBackground().getRGB()));
        }
        if ((color = (Element)(m = this.doc.getElementsByTagName("configuration")).item(0)) != null) {
            m = color.getElementsByTagName("object");
        }
        for (int i = 0; i < m.getLength(); ++i) {
            Element object = (Element)m.item(i);
            object.setAttribute("color", String.valueOf(this.symbolFactory.createSymbol((String)object.getAttribute((String)"name")).color.getRGB()));
        }
        n = this.doc.getElementsByTagName("drawing");
        m = this.doc.getElementsByTagName("erkka");
        Element erkkaE = (Element)m.item(0);
        if (n.getLength() > 0) {
            erkkaE.removeChild(n.item(0));
        }
        Element rootE = this.doc.createElement("drawing");
        erkkaE.appendChild(rootE);
        for (int i = 0; i < this.area.getComponentCount(); ++i) {
            int j;
            Element field;
            Element obj;
            BaseObject o;
            if (this.area.getComponent(i) instanceof Symbol) {
                o = (BaseObject)this.area.getComponent(i);
                obj = this.doc.createElement("object");
                rootE.appendChild(obj);
                obj.setAttribute("name", o.getFieldData(0));
                field = this.doc.createElement("id");
                obj.appendChild(field);
                field.appendChild(this.doc.createTextNode("id".concat(String.valueOf(String.valueOf(String.valueOf(o.GetID()))))));
                field = this.doc.createElement("field");
                obj.appendChild(field);
                field.setAttribute("name", "coordinate_x");
                field.appendChild(this.doc.createTextNode(String.valueOf(o.getX())));
                field = this.doc.createElement("field");
                obj.appendChild(field);
                field.setAttribute("name", "coordinate_y");
                field.appendChild(this.doc.createTextNode(String.valueOf(o.getY())));
                for (j = 1; j < o.getFieldsCount(); ++j) {
                    if (o.getFieldData(j) == null || o.getFieldData(j).trim().length() <= 0) continue;
                    field = this.doc.createElement("field");
                    obj.appendChild(field);
                    field.setAttribute("name", o.getFieldName(j));
                    field.appendChild(this.doc.createTextNode(o.getFieldData(j)));
                }
                continue;
            }
            if (!(this.area.getComponent(i) instanceof Line)) continue;
            o = (BaseObject)this.area.getComponent(i);
            obj = this.doc.createElement("join");
            rootE.appendChild(obj);
            obj.setAttribute("name", "normal");
            field = this.doc.createElement("id");
            obj.appendChild(field);
            field.appendChild(this.doc.createTextNode("id".concat(String.valueOf(String.valueOf(String.valueOf(o.GetID()))))));
            field = this.doc.createElement("idref");
            obj.appendChild(field);
            field.setAttribute("name", "idref1");
            field.appendChild(this.doc.createTextNode("id".concat(String.valueOf(String.valueOf(String.valueOf(((Line)o).GetTarget1().GetID()))))));
            field = this.doc.createElement("idref");
            obj.appendChild(field);
            field.setAttribute("name", "idref2");
            field.appendChild(this.doc.createTextNode("id".concat(String.valueOf(String.valueOf(String.valueOf(((Line)o).GetTarget2().GetID()))))));
            for (j = 1; j < o.getFieldsCount(); ++j) {
                if (o.getFieldData(j) == null || o.getFieldData(j).trim().length() <= 0) continue;
                field = this.doc.createElement("field");
                obj.appendChild(field);
                field.setAttribute("name", o.getFieldName(j));
                field.appendChild(this.doc.createTextNode(o.getFieldData(j)));
            }
        }
        return this.doc;
    }

    public void clearDrawingArea() {
        this.area.removeAll();
        this.area.clearAllVariables();
        this.symbolFactory = null;
        this.infoPanel.setSymbolData(null);
        this.area.repaint();
    }

    public void createNewPicture(String fileName) {
        DOMParser parser = new DOMParser();
        try {
            parser.parse(fileName);
        }
        catch (Exception e) {
            MessageBox msg = new MessageBox();
            msg.setTitle("Error in parsing file ".concat(String.valueOf(String.valueOf(fileName))));
            msg.askOkay(e.getLocalizedMessage());
            return;
        }
        this.doc = parser.getDocument();
        this.configL = this.doc.getElementsByTagName("configuration");
        if (!this.initProgram(this.configL)) {
            MessageBox msg = new MessageBox();
            msg.setTitle("Got some problems.");
            msg.askOkay("The configuration file format is wrong!!");
            return;
        }
        this.area.setModified(false);
    }

    public void setInfoPanelColor(Color newcol) {
        this.infoPanel.setBackground(newcol);
    }

    public void setDrawingAreaColor(Color newcol) {
        this.area.setBackground(newcol);
        this.area.setModified(true);
    }

    public void setLineColor(Color newcol) {
        this.area.getLine().setLineColor(newcol);
        this.area.setModified(true);
    }

    public void print() {
        PrintUtilities.printComponent(this.area);
    }

    public void export(String fileName, DrawingArea _area) {
        _area.setFocusVectorNull();
        int w = _area.getWidth();
        int h = _area.getHeight();
        BufferedImage i = new BufferedImage(w, h, 4);
        _area.paint(i.getGraphics());
        PngEncoderB png = new PngEncoderB(i, false, 0, 5);
        try {
            FileOutputStream outfile = new FileOutputStream(fileName);
            byte[] pngbytes = png.pngEncode();
            if (pngbytes == null) {
                System.out.println("Null image");
            } else {
                outfile.write(pngbytes);
            }
            outfile.flush();
            outfile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSelectedColor(Color newcol) {
        for (int i = 0; i < this.area.getFocusVectorSize(); ++i) {
            this.area.getObject(i).setObjectColor(newcol);
            this.area.setModified(true);
        }
        this.area.repaint();
    }

    public void makesql(JEditorPane sql) {
        if (!this.saveDrawingInFile("temp.tmp", false)) {
            return;
        }
        this.transformationDialog.doTransformation("temp.tmp", sql);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoListener(UndoableEditListener listener) {
        this.undoSupport.addUndoableEditListener(listener);
    }

    public void deleteSelectedObjects() {
        RemoveEdit edit = new RemoveEdit(this.area, this.area.getFocusVector());
        this.undoSupport.postEdit(edit);
        this.area.removeSelectedObjects();
        this.temp = null;
        this.infoPanel.setSymbolData(null);
    }

    public void selectAll() {
        this.area.selectAll();
    }

    public boolean isDravingModifiedAfterLastAsking() {
        return this.area.isModifiedAfterLastAsking();
    }

    public void editSelected() {
        if (this.area.FocusVector.size() != 1) {
            return;
        }
        this.infoPanel.setFocus();
    }
}

