/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.ImageCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MessageBox
implements Runnable,
ActionListener,
WindowListener {
    private ActionListener listener;
    private JDialog dialog;
    private String closeWindowCommand = "CloseRequested";
    private String title;
    private JFrame frame;
    private boolean frameNotProvided;
    private JPanel buttonPanel = new JPanel();
    private Canvas imageCanvas;
    static Class class$erkka$MessageBox;

    public MessageBox(ActionListener listener) {
        this();
        this.listener = listener;
    }

    public MessageBox() {
    }

    public static void main(String[] args) {
        MessageBox box = new MessageBox();
        box.setTitle("Test MessageBox");
        box.useImageCanvas("LightBulb.gif");
        box.askYesNo("Tell me now.\nDo you like Java?");
    }

    public void run() {
        ((Component)this.dialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
        if (this.frameNotProvided) {
            this.frame.dispose();
        }
        if (this.listener != null) {
            this.listener.actionPerformed(evt);
        }
    }

    public void windowClosing(WindowEvent evt) {
        this.fireCloseRequested();
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void keyType(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.fireCloseRequested();
        }
    }

    private void fireCloseRequested() {
        ActionEvent event = new ActionEvent(this, 1001, this.closeWindowCommand);
        this.actionPerformed(event);
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public void setCloseWindowCommand(String command) {
        this.closeWindowCommand = command;
    }

    public void useImageCanvas(Canvas imageCanvas) {
        this.imageCanvas = imageCanvas;
    }

    public void useImageCanvas(String fileName) {
        try {
            ImageCanvas imageCanvas = new ImageCanvas(class$erkka$MessageBox == null ? (class$erkka$MessageBox = MessageBox.class$("erkka.MessageBox")) : class$erkka$MessageBox, fileName);
            this.useImageCanvas(imageCanvas);
        }
        catch (Exception ex) {
            MessageBox.print("MessageBox.helpfulHint() - Cannot load image ".concat(String.valueOf(String.valueOf(fileName))));
            ex.printStackTrace();
        }
    }

    public void addChoice(String label, String command) {
        Button button = new Button(label);
        button.setActionCommand(command);
        button.addActionListener(this);
        this.buttonPanel.add(button);
    }

    public void addChoice(String label, char mnenomic) {
        JButton button = new JButton(label);
        button.setActionCommand(label);
        button.setMnemonic(mnenomic);
        button.addActionListener(this);
        this.buttonPanel.add(button);
    }

    public void addChoice(String label) {
        this.addChoice(label, label);
    }

    public void ask(String message) {
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frameNotProvided = true;
        } else {
            this.frameNotProvided = false;
        }
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.addWindowListener(this);
        this.dialog.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MessageBox.this.keyType(e);
            }
        });
        this.dialog.setTitle(this.title);
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel messagePanel = this.createMultiLinePanel(message);
        if (this.imageCanvas == null) {
            this.dialog.getContentPane().add("Center", messagePanel);
        } else {
            JPanel centerPanel = new JPanel();
            centerPanel.add(this.imageCanvas);
            centerPanel.add(messagePanel);
            this.dialog.add("Center", centerPanel);
        }
        this.dialog.getContentPane().add("South", this.buttonPanel);
        this.dialog.pack();
        this.enforceMinimumSize(this.dialog, 200, 100);
        this.centerWindow(this.dialog);
        Toolkit.getDefaultToolkit().beep();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void askOkay(String message) {
        this.addChoice("Ok", 'O');
        this.ask(message);
    }

    public void askYesNo(String message) {
        this.addChoice("Yes", 'Y');
        this.addChoice("No", 'N');
        this.ask(message);
    }

    private JPanel createMultiLinePanel(String message) {
        JPanel mainPanel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        mainPanel.setLayout(gbLayout);
        this.addMultilineString(message, mainPanel);
        return mainPanel;
    }

    private void addMultilineString(String message, Container container) {
        GridBagConstraints constraints = this.getDefaultConstraints();
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        GridBagLayout gbLayout = (GridBagLayout)container.getLayout();
        while (message.length() > 0) {
            String line;
            int newLineIndex = message.indexOf(10);
            if (newLineIndex >= 0) {
                line = message.substring(0, newLineIndex);
                message = message.substring(newLineIndex + 1);
            } else {
                line = message;
                message = "";
            }
            JLabel label = new JLabel(line);
            gbLayout.setConstraints(label, constraints);
            container.add(label);
        }
    }

    private GridBagConstraints getDefaultConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.insets = new Insets(4, 4, 4, 4);
        constraints.fill = 0;
        constraints.anchor = 17;
        return constraints;
    }

    private void centerWindow(Window win) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenDim.width < win.getSize().width) {
            ((Component)win).setSize(screenDim.width, win.getSize().height);
        }
        if (screenDim.height < win.getSize().height) {
            ((Component)win).setSize(win.getSize().width, screenDim.height);
        }
        int x = (screenDim.width - win.getSize().width) / 2;
        int y = (screenDim.height - win.getSize().height) / 2;
        ((Component)win).setLocation(x, y);
    }

    private void enforceMinimumSize(Component comp, int minWidth, int minHeight) {
        if (comp.getSize().width < minWidth) {
            comp.setSize(minWidth, comp.getSize().height);
        }
        if (comp.getSize().height < minHeight) {
            comp.setSize(comp.getSize().width, minHeight);
        }
    }

    private static void print(String text) {
        System.out.println(text);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

