/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.BaseObject;
import erkka.DrawingArea;
import erkka.Line;
import erkka.RelationBox;
import erkka.Symbol;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;

public class RelationControl {
    private DrawingArea area;
    private BaseObject temp_obj;
    private Symbol foo;
    private int mousepX;
    private int mousepY;
    private Hashtable box_coordinates = new Hashtable();
    private BaseObject temp;
    private Line temp2;

    public RelationControl(DrawingArea area, Hashtable box_coordinates) {
        this.box_coordinates = box_coordinates;
        this.area = area;
    }

    public void setListeners(BaseObject newSymbol) {
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                RelationControl.this.obj_mousePressed(e);
            }
        });
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                RelationControl.this.obj_mouseReleased(e);
            }
        });
        newSymbol.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                RelationControl.this.obj_mouseExited(e);
            }
        });
        newSymbol.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                RelationControl.this.obj_mouseDragged(e);
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void obj_mousePressed(MouseEvent e) {
        this.mousepX = e.getX();
        this.mousepY = e.getY();
        this.temp = (BaseObject)e.getComponent();
        this.area.setFocusVectorNull();
        this.temp.SetObjectFocus(true);
        this.area.repaint();
    }

    public void obj_mouseDragged(MouseEvent e) {
        if (((BaseObject)e.getComponent()).getObjectFocus()) {
            int mx = e.getX() - this.mousepX;
            int my = e.getY() - this.mousepY;
            int dx = this.area.getFocusTableLeft() + mx;
            int dy = this.area.getFocusTableTop() + my;
            if (dx < 0) {
                mx = -this.area.getFocusTableLeft();
                dx = -mx;
            }
            if (dy < 0) {
                my = -this.area.getFocusTableTop();
                dy = -my;
            }
            if (dx > 0 || dy > 0) {
                for (int i = 0; i < this.area.getFocusVectorSize(); ++i) {
                    int x = this.area.getObject(i).getX() + mx;
                    int y = this.area.getObject(i).getY() + my;
                    this.area.getObject(i).setBounds(x, y, this.area.getObject(i).getWidth(), this.area.getObject(i).getHeight());
                }
                this.area.setPreferredSize(new Dimension(Math.max(this.area.getFocusTableRight(), this.area.getWidth()), Math.max(this.area.getFocusTableBottom(), this.area.getHeight())));
                this.area.revalidate();
            }
        }
        this.area.repaint();
    }

    public void obj_mouseReleased(MouseEvent e) {
        this.area.repaint();
        RelationBox b = (RelationBox)e.getSource();
        this.box_coordinates.put(b.getName(), new Point(b.getX(), b.getY()));
    }

    public void obj_mouseExited(MouseEvent e) {
        this.area.repaint();
    }
}

