<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<!--Here is selected every idt/id1 and idt/id2 that belongs right entity and relation-->
<xsl:template match="/">
<all>
<xsl:apply-templates select="a/entity" />
<xsl:apply-templates select="a/attri" />
<xsl:apply-templates select="a/relation" />
</all>
</xsl:template>

<xsl:template match="a/entity">
<entity>
<xsl:variable name="first" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<id><xsl:value-of select="$first" /></id>
<name><xsl:value-of select="name" /></name>
<xsl:for-each select="idt">
<xsl:if test="id1=$first or id2=$first">
<idt>
<xsl:if test="id1=$first">
<id1><xsl:value-of select="id2"/></id1>
<xsl:if test="link=not(empty)">
<link><xsl:value-of select="link"/></link>
</xsl:if>
</xsl:if>
<xsl:if test="id2=$first">
<id1><xsl:value-of select="id1"/></id1>
<xsl:if test="link=not(empty)">
<link><xsl:value-of select="link"/></link>
</xsl:if>
</xsl:if>
</idt>
</xsl:if>
</xsl:for-each>
</entity>
</xsl:template>

<xsl:template match="a/attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:if test="range">
<range><xsl:value-of select="range" /></range>
</xsl:if>
</attri>
</xsl:template>

<xsl:template match="a/relation">
<relation>
<xsl:variable name="second" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<xsl:for-each select="idt">
<xsl:if test="id1=$second or id2=$second">
<xsl:if test="link=not('1') or link=not('M')">
<adt>
<xsl:if test="id1=$second">
<id1><xsl:value-of select="id2"/></id1>
<xsl:if test="link=not(empty)">
<link><xsl:value-of select="link"/></link>
</xsl:if>
</xsl:if>
<xsl:if test="id2=$second">
<id1><xsl:value-of select="id1"/></id1>
<xsl:if test="link=not(empty)">
<link><xsl:value-of select="link"/></link>
</xsl:if>
</xsl:if>
</adt>
</xsl:if>
</xsl:if>
</xsl:for-each>
</relation>
</xsl:template>

</xsl:stylesheet>
 