<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<!-- This xsl-file gives SQL with last xml-file (5.xsl product)-->
<xsl:template match="/">
<xsl:apply-templates select="all/entity" />
<xsl:apply-templates select="all/Relationentity" />
<xsl:apply-templates select="all" />
</xsl:template>
<xsl:template match="all/entity">
<xsl:variable name="first" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<xsl:variable name="second" select="name">
 <xsl:value-of select="name" />
</xsl:variable>
<!-- Next create Many to one related Entity as Table-->
CREATE TABLE <xsl:value-of select="name" /> (
<xsl:for-each select="attri">
<xsl:value-of select="name" /><xsl:text> </xsl:text><xsl:value-of select="type" /><xsl:if test="type='VARCHAR' or type='CHAR' or type='NUMERIC'">(<xsl:value-of select="length" />)</xsl:if><xsl:text> </xsl:text><xsl:value-of select="compu" /> <xsl:if test="default=not(empty)"><xsl:text> </xsl:text><xsl:value-of select="default" /></xsl:if>,
</xsl:for-each>
<xsl:for-each select="ref/attrib">
<xsl:value-of select="name"/><xsl:text> </xsl:text><xsl:value-of select="type"/><xsl:if test="type='VARCHAR' or type='CHAR' or type='NUMERIC'">(<xsl:value-of select="length" />)</xsl:if><xsl:text> </xsl:text><xsl:value-of select="compu" /><xsl:if test="default=not(empty)"><xsl:text> </xsl:text><xsl:value-of select="default" /></xsl:if>,
</xsl:for-each>
CONSTRAINT <xsl:value-of select="$second"/>_PK <!-- If attribute exists with value of primarykey-->
	PRIMARY KEY (<xsl:for-each select="attri"><xsl:if test="primary=not(empty)"><xsl:value-of select="name"/></xsl:if></xsl:for-each>)<xsl:for-each select="ref/attrib">,
CONSTRAINT <xsl:value-of select="$second"/>_<xsl:value-of select="name"/> <!-- Here is selected references from other tables to this table with primarykey-->
	FOREIGN KEY (<xsl:value-of select="name"/>)
	REFERENCES <xsl:value-of select="tablename"/> (<xsl:value-of select="name"/>)
		ON DELETE NO ACTION
		ON UPDATE CASCADE<xsl:if test="not(//ref/attrib[last()])">,</xsl:if>
</xsl:for-each>
<xsl:for-each select="attri/range">
CONSTRAINT <xsl:value-of select="//attri/name"/>_<xsl:value-of select="//attri/name"/>
	CHECK(<xsl:value-of select="//attri/name"/> <xsl:value-of select="./."/>)
</xsl:for-each>
);
</xsl:template>
<xsl:template match="all/Relationentity">
<xsl:variable name="first" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<xsl:variable name="second" select="name">
 <xsl:value-of select="name" />
</xsl:variable>
<!-- Next create Many to Many Relationship from Entity as Table-->
CREATE TABLE <xsl:value-of select="name" /> (
<xsl:for-each select="attri"> <!-- Selected every attribute with name and values-->
<xsl:value-of select="name" /><xsl:text> </xsl:text><xsl:value-of select="type" /><xsl:if test="type='VARCHAR' or type='CHAR' or type='NUMERIC'">(<xsl:value-of select="length" />)</xsl:if><xsl:text> </xsl:text><xsl:value-of select="compu" /> <xsl:if test="default=not(empty)"><xsl:text> </xsl:text><xsl:value-of select="default" /></xsl:if>,
</xsl:for-each>
<xsl:for-each select="ref/attrib">
<xsl:value-of select="tablename"/>_<xsl:value-of select="name"/><xsl:text> </xsl:text><xsl:value-of select="type"/><xsl:if test="type='VARCHAR' or type='CHAR' or type='NUMERIC'">(<xsl:value-of select="length" />)</xsl:if><xsl:text> </xsl:text><xsl:value-of select="compu" /><xsl:if test="default=not(empty)"><xsl:text> </xsl:text><xsl:value-of select="default" /></xsl:if>,
</xsl:for-each>
CONSTRAINT <xsl:value-of select="$second"/>_PK
	PRIMARY KEY (<xsl:for-each select="ref/attrib"><xsl:if test="primary=not(empty)"><xsl:value-of select="tablename"/>_<xsl:value-of select="name"/><xsl:if test="not(name = parent::node()/attrib[last()]/name)">,</xsl:if></xsl:if></xsl:for-each><xsl:for-each select="attri"><xsl:if test="primary=not(empty)">,<xsl:value-of select="name"/></xsl:if></xsl:for-each>)<xsl:for-each select="ref/attrib">,
CONSTRAINT <xsl:value-of select="$second"/>_<xsl:value-of select="name"/> <!-- Here is selected references from other tables to this table with primarykey-->
	FOREIGN KEY (<xsl:value-of select="tablename"/>_<xsl:value-of select="name"/>)
	REFERENCES <xsl:value-of select="tablename"/> (<xsl:value-of select="name"/>)
		ON DELETE NO ACTION
		ON UPDATE CASCADE<xsl:if test="not(//ref/attrib[last()])">,</xsl:if>
</xsl:for-each>
<xsl:for-each select="attri/range">
CONSTRAINT <xsl:value-of select="//attri/name"/>_<xsl:value-of select="//attri/name"/>
	CHECK(<xsl:value-of select="//attri/name"/> <xsl:value-of select="./."/>) <!-- Here is Table's attribute's values check-->
</xsl:for-each>
);
</xsl:template>

<xsl:template match="all"> <!-- Here is created indexs -->
<xsl:for-each select="entity">
<xsl:for-each select="attri">
<xsl:if test="index='true'">
CREATE INDEX<xsl:text> </xsl:text><xsl:value-of select="//name"/>_<xsl:value-of select="name"/><xsl:text> </xsl:text>ON<xsl:text> </xsl:text><xsl:value-of select="//name"/>(<xsl:value-of select="name"/>);</xsl:if>

</xsl:for-each>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>