/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.BaseObject;
import erkka.ErkkaEvent;
import erkka.ErkkaListener;
import erkka.Line;
import erkka.Symbol;
import erkka.SymbolContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JPanel;

public class DrawingArea
extends JPanel {
    private boolean Modified;
    private boolean modifiedAfterLastAsking;
    private int xx1;
    private int xx2;
    private int yy1;
    private int yy2;
    Vector FocusVector = new Vector();
    private Vector LineTable = new Vector();

    public DrawingArea() {
        this.setLayout(null);
        this.Modified = false;
        this.modifiedAfterLastAsking = false;
    }

    public void setLine(int x1, int y1, int x2, int y2) {
        this.xx1 = x1;
        this.xx2 = x2;
        this.yy1 = y1;
        this.yy2 = y2;
    }

    public void paint(Graphics g) {
        super.paint(g);
        for (int j = 0; j < this.LineTable.size(); ++j) {
            ((Line)this.LineTable.elementAt(j)).PaintThis(g);
        }
        g.drawLine(this.xx1, this.yy1, this.xx2, this.yy2);
    }

    public void AddObj(BaseObject obj, int x, int y) {
        this.setModified(true);
        if (!(obj instanceof Line)) {
            obj.addErkkaListener(new ErkkaListener(){

                public void Selected(ErkkaEvent e) {
                    DrawingArea.this.Symb_selected(e);
                }

                public void PropertyChange(ErkkaEvent e) {
                    DrawingArea.this.Symb_changes(e);
                }
            });
            this.add(obj);
            obj.setBounds(x, y, obj.getWidth(), obj.getHeight());
        } else {
            this.LineTable.add(obj);
            this.add(obj);
            obj.addErkkaListener(new ErkkaListener(){

                public void Selected(ErkkaEvent e) {
                    DrawingArea.this.Symb_selected(e);
                }

                public void PropertyChange(ErkkaEvent e) {
                    DrawingArea.this.Symb_changes(e);
                }
            });
        }
    }

    public void Symb_changes(ErkkaEvent e) {
        this.setModified(true);
    }

    public void clearAllVariables() {
        this.LineTable.removeAllElements();
        this.FocusVector.removeAllElements();
        this.xx1 = 0;
        this.xx2 = 0;
        this.yy1 = 0;
        this.yy2 = 0;
    }

    public void removeObj(BaseObject obj) {
        this.setModified(true);
        if (obj instanceof Line) {
            this.LineTable.remove(obj);
        }
        this.remove(obj);
        this.repaint();
    }

    public void Symb_selected(ErkkaEvent e) {
        if (((BaseObject)e.getSource()).getObjectFocus()) {
            this.FocusVector.add((BaseObject)e.getSource());
        }
    }

    public void removeSelectedObjects() {
        this.setModified(true);
        for (int j = 0; j < this.FocusVector.size(); ++j) {
            for (int i = 0; i < this.LineTable.size(); ++i) {
                BaseObject bas = (BaseObject)this.FocusVector.elementAt(j);
                if (bas instanceof SymbolContainer) {
                    SymbolContainer sc = (SymbolContainer)bas;
                    for (int k = 0; k < sc.table.size(); ++k) {
                        this.remove((BaseObject)sc.table.get(k));
                    }
                } else {
                    this.removeFromContainer(bas);
                }
                if (((Line)this.LineTable.elementAt(i)).GetTarget1() != this.FocusVector.elementAt(j) && ((Line)this.LineTable.elementAt(i)).GetTarget2() != this.FocusVector.elementAt(j)) continue;
                this.remove((Line)this.LineTable.elementAt(i));
                this.LineTable.remove(i);
                --i;
            }
            if (this.FocusVector.elementAt(j) instanceof Line) {
                this.LineTable.remove(this.FocusVector.elementAt(j));
            }
            this.remove((BaseObject)this.FocusVector.elementAt(j));
        }
        this.repaint();
    }

    public void removeFromContainer(BaseObject base) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof SymbolContainer)) continue;
            SymbolContainer con = (SymbolContainer)this.getComponent(i);
            for (int j = 0; j < con.table.size(); ++j) {
                if (con.table.get(j) != base) continue;
                con.deleleSymbol(j);
            }
        }
    }

    public BaseObject getObject(int i) {
        return (BaseObject)this.FocusVector.elementAt(i);
    }

    public void setFocusVectorNull() {
        for (int i = 0; i < this.FocusVector.size(); ++i) {
            ((BaseObject)this.FocusVector.elementAt(i)).SetObjectFocus(false);
        }
        this.FocusVector.removeAllElements();
        this.repaint();
    }

    public void removeObjectFromVector(BaseObject rem) {
        rem.SetObjectFocus(false);
        this.FocusVector.remove(rem);
    }

    public int getFocusVectorSize() {
        return this.FocusVector.size();
    }

    public void hideLineHotSpots() {
        if (this.LineTable.size() > 0) {
            boolean status = ((Line)this.LineTable.elementAt(0)).getHotSpotStatus();
            for (int i = 0; i < this.LineTable.size(); ++i) {
                ((Line)this.LineTable.elementAt(i)).isHotSpotShown(!status);
            }
            this.repaint();
        }
    }

    public int getFocusTableLeft() {
        int left = 0;
        if (this.FocusVector.size() == 0) {
            return 0;
        }
        left = ((BaseObject)this.FocusVector.elementAt(0)).getX();
        for (int i = 1; i < this.FocusVector.size(); ++i) {
            BaseObject obj = (BaseObject)this.FocusVector.elementAt(i);
            if (obj.getX() >= left) continue;
            left = obj.getX();
        }
        return left;
    }

    public int getFocusTableRight() {
        int right = this.getX();
        int testx = 0;
        for (int i = 0; i < this.FocusVector.size(); ++i) {
            BaseObject obj = (BaseObject)this.FocusVector.elementAt(i);
            if (obj != null) {
                testx = obj.getX() + obj.getWidth();
            }
            if (testx <= right) continue;
            right = testx;
        }
        return right;
    }

    public int getFocusTableTop() {
        int top = 0;
        if (this.FocusVector.size() == 0) {
            return 0;
        }
        top = ((BaseObject)this.FocusVector.elementAt(0)).getY();
        for (int i = 1; i < this.FocusVector.size(); ++i) {
            BaseObject obj = (BaseObject)this.FocusVector.elementAt(i);
            if (obj.getY() >= top) continue;
            top = obj.getY();
        }
        return top;
    }

    public int getFocusTableBottom() {
        int bottom = this.getY();
        for (int i = 0; i < this.FocusVector.size(); ++i) {
            BaseObject obj = (BaseObject)this.FocusVector.elementAt(i);
            if (obj.getY() + obj.getHeight() <= bottom) continue;
            bottom = obj.getY() + obj.getHeight();
        }
        return bottom;
    }

    public Vector getFocusVector() {
        return this.FocusVector;
    }

    public void setFocusVector(Vector newVector) {
        this.FocusVector = newVector;
    }

    public Symbol getObjByID(int id) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof Symbol) || ((Symbol)this.getComponent(i)).GetID() != id) continue;
            return (Symbol)this.getComponent(i);
        }
        return null;
    }

    public Line getLine() {
        return (Line)this.LineTable.elementAt(0);
    }

    public Vector getLineTable() {
        return this.LineTable;
    }

    public boolean getModified() {
        return this.Modified;
    }

    public boolean isModifiedAfterLastAsking() {
        if (this.modifiedAfterLastAsking) {
            this.modifiedAfterLastAsking = false;
            return true;
        }
        return false;
    }

    public void setModified(boolean newVal) {
        this.Modified = newVal;
        this.modifiedAfterLastAsking = newVal;
    }

    public void setSelectedObjectsPos(int dx, int dy) {
        if (dx < 0) {
            dx = this.getFocusTableLeft();
        }
        if (dy < 0) {
            dy = this.getFocusTableTop();
        }
        int mx = dx - this.getFocusTableLeft();
        int my = dy - this.getFocusTableTop();
        if (dx > 0 || dy > 0) {
            for (int i = 0; i < this.getFocusVectorSize(); ++i) {
                int x = this.getObject(i).getX() + mx;
                int y = this.getObject(i).getY() + my;
                this.getObject(i).setBounds(x, y, this.getObject(i).getWidth(), this.getObject(i).getHeight());
            }
            this.setModified(true);
            this.setPreferredSize(new Dimension(Math.max(this.getFocusTableRight(), this.getWidth()), Math.max(this.getFocusTableBottom(), this.getHeight())));
            this.revalidate();
        }
        this.invalidate();
    }

    public void moveSelectedObjects(int mx, int my) {
        int dx = this.getFocusTableLeft() + mx;
        int dy = this.getFocusTableTop() + my;
        if (dx < 0) {
            mx = -this.getFocusTableLeft();
            dx = -mx;
        }
        if (dy < 0) {
            my = -this.getFocusTableTop();
            dy = -my;
        }
        if (dx > 0 || dy > 0) {
            for (int i = 0; i < this.getFocusVectorSize(); ++i) {
                int x = this.getObject(i).getX() + mx;
                int y = this.getObject(i).getY() + my;
                this.getObject(i).setBounds(x, y, this.getObject(i).getWidth(), this.getObject(i).getHeight());
            }
            this.setModified(true);
            this.setPreferredSize(new Dimension(Math.max(this.getFocusTableRight(), this.getWidth()), Math.max(this.getFocusTableBottom(), this.getHeight())));
            this.revalidate();
        }
        this.repaint();
    }

    public void selectAll() {
        Component[] t = this.getComponents();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            BaseObject b = (BaseObject)t[i];
            b.SetObjectFocus(true);
        }
        this.repaint();
    }
}

