/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.InputStream;

public class ImageCanvas
extends Canvas {
    private Image image;

    public ImageCanvas(Image image) {
        this.loadImage(image);
    }

    public ImageCanvas(Class resourceClass, String resourceName) {
        try {
            InputStream resource = resourceClass.getResourceAsStream(resourceName);
            byte[] bytes = new byte[resource.available()];
            resource.read(bytes);
            Image image = Toolkit.getDefaultToolkit().createImage(bytes);
            this.loadImage(image);
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("ImageCanvas() - Cannot load '").append(resourceName).append("' with class '").append(resourceClass.getName()).append("'."))));
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
    }

    private void loadImage(Image image) {
        this.image = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            System.out.println("Cannot load image");
        }
        this.setSize(image.getWidth(null), image.getHeight(null));
    }
}

