/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.BaseObject;
import erkka.PropDataField;
import erkka.Proper;
import erkka.SymbolFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InformationPanel
extends JPanel {
    BaseObject currSymbol;
    Vector pNames = new Vector();
    Vector pDatas = new Vector();
    SymbolFactory sFactory;

    public InformationPanel() {
        this.setLayout(null);
        for (int i = 0; i < 50; ++i) {
            this.pNames.add(new JLabel("testi"));
            this.pDatas.add(new PropDataField());
        }
        for (int i = 0; i < this.pNames.size(); ++i) {
            JLabel pComp = (JLabel)this.pNames.get(i);
            this.add(pComp);
            pComp.setBounds(3, 60 + 24 * i, 65, 22);
            PropDataField pData = (PropDataField)this.pDatas.get(i);
            this.add(pData);
            pData.setBounds(68, 60 + 24 * i, 85, 22);
            pData.setIndex(i);
            pComp.setVisible(false);
            pData.setVisible(false);
            pData.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    InformationPanel.this.pData_keyType(e);
                }
            });
        }
    }

    public void setSymbolF(SymbolFactory symbF) {
        this.sFactory = symbF;
    }

    public void removeComboAndCheckBoxes() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component o = this.getComponent(i);
            if (!(o instanceof JComboBox) && !(o instanceof JCheckBox)) continue;
            this.remove(i);
            --i;
        }
    }

    public void setSymbolData(BaseObject symb) {
        if (this.currSymbol != null) {
            this.saveOldSymbolData();
        }
        this.removeComboAndCheckBoxes();
        this.currSymbol = symb;
        if (symb == null) {
            this.hideProperties(0);
            return;
        }
        this.hideProperties(symb.getFieldsCount());
        for (int i = 1; i < symb.getFieldsCount(); ++i) {
            ((JLabel)this.pNames.get(i)).setText(symb.getFieldName(i));
            if (symb.getFieldDataType(i) != null && symb.getFieldDataType(i).length() > 1) {
                this.createSelection(i, symb.getFieldDataType(i));
                continue;
            }
            ((PropDataField)this.pDatas.get(i)).setText(symb.getFieldData(i));
            ((PropDataField)this.pDatas.get(i)).setIndex(i);
        }
    }

    public void saveOldSymbolData() {
        for (int i = 1; i < this.currSymbol.getFieldsCount(); ++i) {
            if (this.currSymbol.getFieldDataType(i) != null && this.currSymbol.getFieldDataType(i).length() > 1) {
                this.currSymbol.SetProperty(this.getSelectionData(i), i);
                String name = ((JLabel)this.pNames.get(i + 1)).getText();
                if (name.equalsIgnoreCase(this.currSymbol.getFieldName(i + 1))) continue;
                this.currSymbol.setNewField(name, null, null, i + 1);
                continue;
            }
            this.currSymbol.SetProperty(((PropDataField)this.pDatas.get(i)).getText(), i);
        }
    }

    public String getSelectionData(int i) {
        for (int j = 0; j < this.getComponentCount(); ++j) {
            JComboBox cb;
            JCheckBox b;
            if (this.getComponent(j) instanceof JCheckBox && (b = (JCheckBox)this.getComponent(j)).getName().equalsIgnoreCase(String.valueOf(i))) {
                if (b.isSelected()) {
                    return "true";
                }
                return " ";
            }
            if (!(this.getComponent(j) instanceof JComboBox) || !(cb = (JComboBox)this.getComponent(j)).getName().equalsIgnoreCase(String.valueOf(i))) continue;
            return (String)cb.getSelectedItem();
        }
        return "error";
    }

    public void createSelection(int i, String type) {
        PropDataField p = (PropDataField)this.pDatas.get(i);
        p.setVisible(false);
        JComponent selectionBox = this.sFactory.createSelection(type);
        this.add(selectionBox);
        p.setComponentOverSelf(selectionBox);
        if (selectionBox instanceof JComboBox) {
            this.installData((JComboBox)selectionBox, i);
        }
        if (selectionBox instanceof JCheckBox) {
            this.installData((JCheckBox)selectionBox, i);
        }
    }

    public void installData(JComboBox box, int i) {
        box.setSelectedItem(this.currSymbol.getFieldData(i));
        box.setName(String.valueOf(i));
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InformationPanel.this.comboBoxChoiceSelected(e);
            }
        });
        box.revalidate();
    }

    public void installData(JCheckBox box, int i) {
        if (this.currSymbol.getFieldData(i).equalsIgnoreCase("true")) {
            box.setSelected(true);
        } else {
            box.setSelected(false);
        }
        box.setName(String.valueOf(i));
    }

    public void pData_keyType(KeyEvent e) {
        PropDataField temp = (PropDataField)e.getComponent();
        if (this.currSymbol == null) {
            return;
        }
        this.currSymbol.SetProperty(temp.getText(), temp.getIndexInT());
        this.currSymbol.repaint();
    }

    public void hideProperties(int Count) {
        int i;
        for (i = 1; i <= this.pNames.size() - Count; ++i) {
            ((JComponent)this.pNames.get(this.pNames.size() - i)).setVisible(false);
            ((JComponent)this.pDatas.get(this.pNames.size() - i)).setVisible(false);
        }
        for (i = 0; i < Count; ++i) {
            ((JComponent)this.pNames.get(i)).setVisible(true);
            ((JComponent)this.pDatas.get(i)).setVisible(true);
        }
        ((JComponent)this.pNames.get(0)).setVisible(false);
        ((JComponent)this.pDatas.get(0)).setVisible(false);
    }

    public void comboBoxChoiceSelected(ActionEvent e) {
        JComboBox box = (JComboBox)e.getSource();
        String text = (String)box.getSelectedItem();
        Proper proper = this.sFactory.getChoiceProper(text);
        int index = Integer.parseInt(box.getName());
        this.removeOldExtra(box, index);
        if (proper == null) {
            return;
        }
        this.moveDown(24, index);
        PropDataField field = new PropDataField();
        field.setText(proper.getPData());
        this.pDatas.insertElementAt(field, index + 1);
        this.add(field);
        field.setBounds(68, 60 + 24 * (index + 1), 85, 22);
        JLabel lab = new JLabel(proper.getPName());
        this.pNames.insertElementAt(lab, index + 1);
        this.add(lab);
        lab.setBounds(3, 60 + 24 * (index + 1), 65, 22);
        this.currSymbol.setNewField(proper.getPName(), proper.getPData(), proper.getPDType(), index + 1);
    }

    public boolean isThereOldExtraField(JComboBox box, int index) {
        for (int i = 0; i < box.getItemCount(); ++i) {
            Proper p = this.sFactory.getChoiceProper((String)box.getItemAt(i));
            if (p == null || !p.getPName().equalsIgnoreCase(((JLabel)this.pNames.get(index + 1)).getText())) continue;
            return true;
        }
        return false;
    }

    public void removeOldExtra(JComboBox box, int index) {
        if (!this.isThereOldExtraField(box, index)) {
            return;
        }
        this.currSymbol.removeField(index + 1);
        this.currSymbol.SetProperty((String)box.getSelectedItem(), index);
        this.remove((JComponent)this.pDatas.get(index + 1));
        this.pDatas.remove(index + 1);
        this.remove((JComponent)this.pNames.get(index + 1));
        this.pNames.remove(index + 1);
        this.moveDown(-24, index);
    }

    public void moveDown(int move, int index) {
        int i;
        int index2 = move;
        if (move < 0) {
            index2 = -1;
        } else if (move > 0) {
            index2 = 1;
        }
        for (i = index + 1; i < this.pDatas.size(); ++i) {
            PropDataField pF = (PropDataField)this.pDatas.get(i);
            pF.setIndex(pF.getIndexInT() + index2);
            pF.moveUpOrDown(move);
        }
        for (i = index + 1; i < this.pNames.size(); ++i) {
            JComponent c = (JComponent)this.pNames.get(i);
            c.setBounds(c.getX(), c.getY() + move, c.getWidth(), c.getHeight());
        }
    }

    public void setFocus() {
        ((JTextField)this.pDatas.get(1)).requestFocus();
    }
}

