/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.Vista;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

public class JComponentVista
extends Vista
implements Printable {
    private static final boolean SYMMETRIC_SCALING = true;
    private static final boolean ASYMMETRIC_SCALING = false;
    private double mScaleX;
    private double mScaleY;
    private JComponent mComponent;

    public JComponentVista(JComponent c, PageFormat format) {
        this.setPageFormat(format);
        this.setPrintable(this);
        this.setComponent(c);
        Rectangle componentBounds = c.getBounds(null);
        this.setSize(componentBounds.width, componentBounds.height);
        this.setScale(1.0, 1.0);
    }

    protected void setComponent(JComponent c) {
        this.mComponent = c;
    }

    protected void setScale(double scaleX, double scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
    }

    public void scaleToFitX() {
        double scaleX;
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.mComponent.getBounds(null);
        double scaleY = scaleX = format.getImageableWidth() / (double)componentBounds.width;
        if (scaleX < 1.0) {
            this.setSize((float)format.getImageableWidth(), (float)((double)componentBounds.height * scaleY));
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFitY() {
        double scaleY;
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.mComponent.getBounds(null);
        double scaleX = scaleY = format.getImageableHeight() / (double)componentBounds.height;
        if (scaleY < 1.0) {
            this.setSize((float)((double)componentBounds.width * scaleX), (float)format.getImageableHeight());
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFit(boolean useSymmetricScaling) {
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.mComponent.getBounds(null);
        double scaleX = format.getImageableWidth() / (double)componentBounds.width;
        double scaleY = format.getImageableHeight() / (double)componentBounds.height;
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Scale: ").append(scaleX).append(" ").append(scaleY))));
        if (scaleX < 1.0 || scaleY < 1.0) {
            if (useSymmetricScaling) {
                if (scaleX < scaleY) {
                    scaleY = scaleX;
                } else {
                    scaleX = scaleY;
                }
            }
            this.setSize((float)((double)componentBounds.width * scaleX), (float)((double)componentBounds.height * scaleY));
            this.setScale(scaleX, scaleY);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle componentBounds = this.mComponent.getBounds(null);
        g2.translate(-componentBounds.x, -componentBounds.y);
        g2.scale(this.mScaleX, this.mScaleY);
        boolean wasBuffered = this.mComponent.isDoubleBuffered();
        this.mComponent.paint(g2);
        this.mComponent.setDoubleBuffered(wasBuffered);
        return 0;
    }

    static {
        SYMMETRIC_SCALING = true;
        ASYMMETRIC_SCALING = false;
    }
}

