/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.DrawingArea;
import erkka.Reference;
import erkka.RelLine;
import erkka.Relation;
import erkka.RelationBox;
import erkka.RelationControl;
import erkka.Relations;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RelDrawingPanel
extends JPanel {
    int marginal = 10;
    int spaceBetweenBoxes = 200;
    DrawingArea panel;
    Hashtable box_coordinates = new Hashtable();

    public void drawRelation(String fileName) {
        Relation rel;
        if (this.panel != null) {
            this.removeAll();
            this.panel = null;
        }
        Relations relations = new Relations();
        relations.readFile(fileName);
        this.panel = new DrawingArea();
        this.add(this.panel);
        this.panel.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.panel.setBackground(Color.white);
        this.panel.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        JScrollPane scrollPane = new JScrollPane(this.panel);
        this.add(scrollPane);
        this.panel.setLayout(null);
        RelationControl rc = new RelationControl(this.panel, this.box_coordinates);
        Hashtable<String, RelationBox> tables = new Hashtable<String, RelationBox>();
        int i = 0;
        int j = 0;
        RelationBox box = null;
        Enumeration e = relations.getCreateTables().elements();
        while (e.hasMoreElements()) {
            rel = (Relation)e.nextElement();
            int x = j * this.spaceBetweenBoxes + this.marginal;
            int y = i * this.spaceBetweenBoxes + this.marginal;
            box = new RelationBox(rel);
            this.panel.AddObj(box, x, y);
            if (this.box_coordinates.containsKey(box.getName())) {
                Point p = (Point)this.box_coordinates.get(box.getName());
                x = p.x;
                y = p.y;
                box.setBounds(x, y, 70, 50);
            } else {
                box.setBounds(x, y, 70, 50);
                this.box_coordinates.put(box.getName(), new Point(x, y));
            }
            rc.setListeners(box);
            tables.put(box.getName(), box);
            if (j < 3) {
                ++j;
                continue;
            }
            ++i;
            j = 0;
        }
        e = relations.getCreateTables().elements();
        while (e.hasMoreElements()) {
            rel = (Relation)e.nextElement();
            Vector lines = rel.getLines();
            for (i = 0; i < lines.size(); ++i) {
                Reference ref = (Reference)lines.get(i);
                RelLine line = new RelLine(ref.getTarget1Attribute(), ref.getTarget2Attribute());
                RelationBox src = (RelationBox)tables.get(rel.getTableName());
                RelationBox dst = (RelationBox)tables.get(ref.getTableTarget2());
                if (src != null && dst != null) {
                    line.SetTarget1(src);
                    line.SetTarget2(dst);
                    line.setInfo(ref.getCascade());
                }
                this.panel.AddObj(line, 0, 0);
                line.updateLines();
            }
            ++i;
            this.panel.repaint();
        }
        this.panel.selectAll();
        this.panel.setPreferredSize(new Dimension(this.panel.getFocusTableRight() + 100, this.panel.getFocusTableBottom() + 100));
        this.panel.revalidate();
        this.panel.setFocusVectorNull();
        this.panel.repaint();
    }

    DrawingArea getDrawingArea() {
        return this.panel;
    }
}

