/*
 * Decompiled with CFR 0.152.
 */
package erkka;

import erkka.HotSpot;
import erkka.Relation;
import erkka.Symbol;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Vector;

public class RelationBox
extends Symbol {
    Relation relation;
    int attributeHeight = 15;
    int attributeStart = 25;
    int lineSpace = 15;
    int maxWidth = 0;
    Font nameFont = new Font("SansSerif", 0, 16);
    Font pkFont = new Font("SansSerif", 1, 12);
    Font attrFont = new Font("SansSerif", 0, 12);
    Hashtable attributes = null;
    double textHeight = 0.0;

    public RelationBox(Relation relation) {
        this.relation = relation;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.attributes == null) {
            this.createAttributeHash(g2);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        g2.setColor(Color.black);
        TextLayout tl = new TextLayout(this.relation.getTableName(), this.nameFont, frc);
        Rectangle2D r2d = tl.getBounds();
        tl.draw(g2, 5.0f, (float)(r2d.getHeight() + (double)3));
        int ypos = this.attributeStart;
        for (int i = 0; i < this.relation.getAttributes().size(); ++i) {
            tl = (TextLayout)this.attributes.get((String)this.relation.getAttributes().get(i));
            tl.draw(g2, 10.0f, (float)(r2d.getHeight() + (double)ypos));
            ypos += this.attributeHeight;
        }
        this.setBounds(this.getX(), this.getY(), this.maxWidth + 20, this.relation.getAttributes().size() * this.attributeHeight + this.attributeStart + 5);
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2.drawLine(0, this.attributeStart, this.getWidth(), this.attributeStart);
    }

    int getAttributePos(String attrname) {
        for (int i = 0; i < this.relation.getAttributes().size(); ++i) {
            Vector v = this.relation.getAttributes();
            if (!v.get(i).equals(attrname)) continue;
            return i;
        }
        return -1;
    }

    public HotSpot GetNearest(Point foo, String attrname) {
        if (attrname == null) {
            return new HotSpot(this.getX(), this.getY());
        }
        int pos = this.getAttributePos(attrname);
        if (foo.getX() > (double)this.getX()) {
            return new HotSpot(this.getX() + this.getWidth() + this.lineSpace, this.getY() + this.attributeStart + pos * this.attributeHeight + 5);
        }
        return new HotSpot(this.getX() - this.lineSpace, this.getY() + this.attributeStart + pos * this.attributeHeight + 5);
    }

    int getVerticalSpace(int cmpPoint) {
        if (cmpPoint > this.getX()) {
            return -this.lineSpace;
        }
        return this.lineSpace;
    }

    public String getName() {
        return this.relation.getTableName();
    }

    public void createAttributeHash(Graphics2D g2) {
        FontRenderContext frc = g2.getFontRenderContext();
        this.attributes = new Hashtable();
        TextLayout tl = new TextLayout(this.relation.getTableName(), this.nameFont, frc);
        Rectangle2D r2d = tl.getBounds();
        this.maxWidth = (int)r2d.getWidth();
        for (int i = 0; i < this.relation.getAttributes().size(); ++i) {
            String attrname = (String)this.relation.getAttributes().get(i);
            if (this.relation.isPrimaryKey(attrname)) {
                tl = new TextLayout(attrname, this.pkFont, frc);
                this.attributes.put(attrname, tl);
            } else {
                tl = new TextLayout(attrname, this.attrFont, frc);
                this.attributes.put(attrname, tl);
            }
            r2d = tl.getBounds();
            if (r2d.getWidth() > (double)this.maxWidth) {
                this.maxWidth = (int)r2d.getWidth();
            }
            this.textHeight = r2d.getHeight();
        }
    }
}

