<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<!--This XSL-file adds every entity and relationship join-elements-->
<xsl:template match="/">
<a>
<xsl:apply-templates select="erkka/drawing/object[@name='Entity']" /> 
<xsl:apply-templates select="//erkka/drawing/object[@name='Attribute']" />
<xsl:apply-templates select="erkka/drawing/object[@name='Relationship']" />
</a>  
</xsl:template>

<!--Here is copied every entity with joins-->
<xsl:template match="erkka/drawing/object[@name='Entity']">
<entity>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="field[@name='name']" /></name>
<xsl:apply-templates select="//erkka/drawing/join"/>
</entity>
</xsl:template>

<xsl:template match="//erkka/drawing/join">
<idt>
<id1>
<xsl:value-of select="idref[@name='idref1']"/>
</id1>
<id2>
<xsl:value-of select="idref[@name='idref2']"/>
</id2>
<xsl:if test="field[@name='cardinality']='M' or field[@name='cardinality']='1'">
<link>
<xsl:value-of select="field[@name='cardinality']"/>
</link>
</xsl:if>
</idt>
</xsl:template>

<!--Here is copied data of attributes to attris--> 
<xsl:template match="//erkka/drawing/object[@name='Attribute']">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="field[@name='name']" /></name>
<type><xsl:value-of select="field[@name='type']" /></type>
<length><xsl:value-of select="field[@name='length']" /></length>
<compu><xsl:value-of select="field[@name='compulsion']" /></compu>
<xsl:if test="field[@name='primarykey']=not(empty)">
<primary><xsl:value-of select="field[@name='primarykey']" /></primary>
</xsl:if>
<xsl:if test="field[@name='index']=not(empty)">
<index><xsl:value-of select="field[@name='index']" /></index>
</xsl:if>
<xsl:if test="field[@name='value']=not(empty)">
<default><xsl:value-of select="field[@name='value']"/></default>
</xsl:if>
<xsl:for-each select="field[@name='range']">
<range><xsl:value-of select="./."/></range>
</xsl:for-each>
</attri>
</xsl:template>

<!--Here is copied data of relationships to relations-->
<xsl:template match="erkka/drawing/object[@name='Relationship']">
<relation>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="field[@name='name']" /></name>
<xsl:apply-templates select="//erkka/drawing/join"/>
</relation>
</xsl:template>

</xsl:stylesheet>
 