<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<!--This XSL-file creates every many to many relationships as relationentities-->
<!--This also changes every one to one-relationships as many to one-relationships-->
<xsl:template match="/">
<all>
<xsl:apply-templates select="all/entity" />
<xsl:call-template name="relate"/>
<xsl:apply-templates select="all/relation" />
</all>
</xsl:template>

<xsl:template match="all/entity">
<xsl:variable name="first" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<entity>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<xsl:for-each select="idt">
<xsl:if test="id1=not(empty)">
<idt>
<id1><xsl:value-of select="id1"/></id1>
<xsl:if test="link">
<link><xsl:value-of select="link"/></link>
</xsl:if>
</idt>
</xsl:if>
</xsl:for-each>
<xsl:for-each select="attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>
</xsl:for-each>
</attri>
</xsl:for-each>
</entity>
</xsl:template>

<xsl:template match="all/relation">
<!--Here is changed every one to one-relation as many to one-relation-->
<xsl:if test="(idtt/idt[1]/link='1') and (idtt/idt[2]/link='1')">
<relation>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<idtt>
<idt>
<id1><xsl:value-of select="idtt/idt/id1"/></id1>
<link>M</link>
</idt>
<idt>
<id1><xsl:value-of select="idtt/idt[last()]/id1"/></id1>
<link>1</link>
</idt>
</idtt>
<xsl:for-each select="attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attri>
</xsl:for-each>
</relation>
</xsl:if>

<!-- Here is copied every many to one-relation-->
<xsl:if test="(idtt/idt/link='1' and idtt/idt[last()]/link='M') or (idtt/idt/link='M' and idtt/idt[last()]/link='1')">
<relation>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<idtt>
<xsl:for-each select="idtt/idt">
<idt>
<id1><xsl:value-of select="id1"/></id1>
<link><xsl:value-of select="link"/></link>
</idt>
</xsl:for-each>
</idtt>
<xsl:for-each select="attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attri>
</xsl:for-each>
</relation>
</xsl:if>
<xsl:for-each select="idtt/idt">
<xsl:variable name="many" select="id1">
 <xsl:value-of select="id1" />
</xsl:variable>
<xsl:if test="link='M' and parent::node()/idt[last()]/link='M' and many=not(parent::node()/idt[last()]/id1)">
<relation>
<id><xsl:value-of select="parent::node()/parent::node()/id"/><xsl:value-of select="many"/></id>
<name><xsl:value-of select="parent::node()/parent::node()/name"/><xsl:value-of select="parent::node()/parent::node()/name"/></name>
<idtt>
<idt>
<id1><xsl:value-of select="parent::node()/parent::node()/id"/></id1>
<link>M</link>
</idt>
<idt>
<id1><xsl:value-of select="$many"/></id1>
<link>1</link>
</idt>
</idtt>
</relation>
</xsl:if>
</xsl:for-each>
</xsl:template>

<!--This changes every many to many as relationentity-->
<!--Same time is created two new relationships for new entity(called relationentity)-->
<xsl:template name="relate">
<xsl:for-each select="//relation">
<xsl:variable name="third" select="idtt/idt/id1">
 <xsl:value-of select="idtt/idt/id1" />
</xsl:variable>
<xsl:if test="idtt/idt[1]/link='M' and idtt/idt[last()]/link='M'">
<Relationentity>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<xsl:for-each select="attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attri>
</xsl:for-each>
</Relationentity>
</xsl:if>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>