<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<!--This XSL-file joins right datas every entity and relationentity so every entity and relationentity can be read as table for SQL-->
<xsl:template match="/">
<all>
<xsl:apply-templates select="all/entity" />
<xsl:apply-templates select="all/Relationentity" />
</all>
</xsl:template>
<!-- Here is copied data of every entity with attris(attributes)-->
<xsl:template match="all/entity">
<xsl:variable name="first" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<entity>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<xsl:for-each select="attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>
</xsl:for-each>
</attri>
</xsl:for-each>
<ref>
<xsl:call-template name="relation">           <!--Here is added every right relation as ref to entity-->
<xsl:with-param name="first" select="$first"/>
</xsl:call-template>
</ref>
</entity>
</xsl:template>

<!-- Here is copied data of every relationentity with attris(attributes)-->
<xsl:template match="all/Relationentity">
<xsl:variable name="first" select="id">
 <xsl:value-of select="id" />
</xsl:variable>
<Relationentity>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<xsl:for-each select="attri">
<attri>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>
</xsl:for-each>
</attri>
</xsl:for-each>
<ref>
<xsl:call-template name="Relrelation">           <!--Here is added every right Relrelation as ref to Relationentity-->
<xsl:with-param name="first" select="$first"/>
</xsl:call-template>
</ref>
</Relationentity>
</xsl:template>

<!--Here is copied data of relation-->
<xsl:template name="relation">
<xsl:for-each select="//relation">
<xsl:if test="idtt/idt[1]/id1=$first and idtt/idt[1]/link='M'">
<xsl:variable name="second" select="idtt/idt[last()]/id1"> 
 <xsl:value-of select="idtt/idt[last()]/id1" />
</xsl:variable>
<xsl:for-each select="//entity">
<xsl:if test="id=$second">
<xsl:for-each select="attri">
<xsl:if test="primary=not(empty)">
<attrib>
<tablename><xsl:value-of select="parent::node()/name" /></tablename>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attrib>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>

<xsl:if test="idtt/idt[last()]/id1=$first and idtt/idt[last()]/link='M'">
<xsl:variable name="second" select="idtt/idt[1]/id1"> 
 <xsl:value-of select="idtt/idt[1]/id1" />
</xsl:variable>
<xsl:for-each select="//entity">
<xsl:if test="id=$second">
<xsl:for-each select="attri">
<xsl:if test="primary=not(empty)">
<attrib>
<tablename><xsl:value-of select="parent::node()/name" /></tablename>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attrib>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:template>

<!--Here is copied data of Relrelation-->
<xsl:template name="Relrelation">
<xsl:for-each select="//relation">
<xsl:if test="idtt/idt[1]/id1=$first and idtt/idt[1]/link='M'">
<xsl:variable name="second" select="idtt/idt[last()]/id1"> 
 <xsl:value-of select="idtt/idt[last()]/id1" />
</xsl:variable>
<xsl:for-each select="//entity">
<xsl:if test="id=$second">
<xsl:for-each select="attri">
<xsl:if test="primary=not(empty)">
<attrib>
<tablename><xsl:value-of select="parent::node()/name" /></tablename>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attrib>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
<xsl:if test="idtt/idt[last()]/id1=$first and idtt/idt[last()]/link='M'">
<xsl:variable name="second" select="idtt/idt[1]/id1"> 
 <xsl:value-of select="idtt/idt[1]/id1" />
</xsl:variable>
<xsl:for-each select="//entity">
<xsl:if test="id=$second">
<xsl:for-each select="attri">
<xsl:if test="primary=not(empty)">
<attrib>
<tablename><xsl:value-of select="parent::node()/name" /></tablename>
<id><xsl:value-of select="id" /></id>
<name><xsl:value-of select="name" /></name>
<type><xsl:value-of select="type" /></type>
<length><xsl:value-of select="length" /></length>
<compu><xsl:value-of select="compu" /></compu>
<xsl:if test="primary=not(empty)">
<primary><xsl:value-of select="primary" /></primary>
</xsl:if>
<xsl:if test="index=not(empty)">
<index><xsl:value-of select="index" /></index>
</xsl:if>
<xsl:if test="default=not(empty)">
<default><xsl:value-of select="default" /></default>
</xsl:if>
<xsl:for-each select="range">
<range><xsl:value-of select="./." /></range>     <!-- selects every range -->
</xsl:for-each>
</attrib>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>